/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.signal;

/**
 * This interface contains all the Signaling Codes for deciphering methods, packet types and results.
 */
public interface SignalID
{
	/***************** Method IDs ******************/
	
	/** Dial Method ID **/
	public static final int DIAL = 1;
	/** Hangup Method ID **/
	public static final int HANGUP = 2;
	/** SendDTMF Method ID **/
	public static final int SENDDTMF = 3;
	/** Alive Method ID **/
	public static final int ALIVEQUERY = 4;
	
	/***************** Packet Types ******************/
	
	/** Invite Packet **/
	public static final int INVITE = 300;
	/** Result Packet **/
	public static final int RESULT = 301;
	/** Confirm Packet **/
	public static final int CONFIRM = 302;
	
	/*****************  Result Types ******************/
	
	/** Call accepted  **/
	public static final int ACCEPT = 701;
	/** Call rejected  **/
	public static final int REJECT = 702;
	/** User busy  **/
	public static final int BUSY = 703;
	/** Request confirmed (isAlive == true)  **/
	public static final int CONFIRMED = 704;
	/** Peer not responding, timeout  **/
	public static final int TIMEOUT = 705;
	/** Peer not compatible  **/
	public static final int INCOMPATIBLE = 706;	
	/** Peer not valid **/
	public static final int INVALID = -1;
}
